﻿//////////////////////////////////////////////
// MouseDevice.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkInputs
{
	class System ;
}

/// Includes ---------------------------------

// nkInputs
#include "../../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------
	
namespace nkInputs
{
	class DLL_INPUTS_EXPORT MouseDevice
	{		
		public :
		
			// Constructor, destructor
			MouseDevice (System* system) noexcept ;
			virtual ~MouseDevice () ;

			// Getters
			System* getSystem () const ;
			virtual int getX () const = 0 ;
			virtual int getY () const = 0 ;
			virtual long getLastXMovement () const = 0 ;
			virtual long getLastYMovement () const = 0 ;
			virtual long getLastZMovement () const = 0 ;
			virtual bool getLeftButton () const = 0 ;
			virtual bool getRightButton () const = 0 ;
			virtual bool getCenterButton () const = 0 ;

			// Update
			virtual void update () = 0 ;

		public :

			// Statics
			// Creation
			static nkMemory::UniquePtr<MouseDevice> create (System* system = nullptr) ;

		protected :

			System* _system ;
	} ;
}